// ---------------------------------------------------------------------------------------
//  IRQH.C - IRQ Handler (ˋ̃foCXɂ)
// ---------------------------------------------------------------------------------------

#include "../win32/common.h"
#include "m68000.h"
#include "irqh.h"

	BYTE	IRQH_IRQ[8];
	void	*IRQH_CallBack[8];

void Save_IRQH( FILE *fp )
{
	//fwrite( &DMA_LastInt, 1, sizeof(DMA_LastInt), fp );
	fwrite( IRQH_IRQ, 1, sizeof(IRQH_IRQ), fp );
	//fwrite( IRQH_CallBack, 1, sizeof(IRQH_CallBack), fp );
}

void Load_IRQH( FILE *fp )
{
	//fread( &DMA_LastInt, 1, sizeof(DMA_LastInt), fp );
	fread( IRQH_IRQ, 1, sizeof(IRQH_IRQ), fp );
	//fread( IRQH_CallBack, 1, sizeof(IRQH_CallBack), fp );
}


// -----------------------------------------------------------------------
//   
// -----------------------------------------------------------------------
void IRQH_Init(void)
{
	ZeroMemory(IRQH_IRQ, 8);
}


// -----------------------------------------------------------------------
//   ftHg̃xN^ԂiꂪNςj
// -----------------------------------------------------------------------
DWORD FASTCALL IRQH_DefaultVector(BYTE irq)
{
	IRQH_IRQCallBack(irq);
	return -1;
}


// -----------------------------------------------------------------------
//   ̊荞݂̃`FbN
//   efoCX̃xN^Ԃ[`Ă΂܂
// -----------------------------------------------------------------------
void IRQH_IRQCallBack(BYTE irq)
{
	int i;
	IRQH_IRQ[irq] = 0;
	regs.IRQ_level = 0;
	for (i=7; i>0; i--)
	{
		if (IRQH_IRQ[i])
		{
			regs.irq_callback = IRQH_CallBack[i];
			regs.IRQ_level = i;
			if ( m68000_ICount ) {					// d荞ݎiCARATj
				m68000_ICountBk += m68000_ICount;		// IɊ荞݃`FbN
				m68000_ICount = 0;				// ̍ ^^;
			}
			break;
		}
	}
}


// -----------------------------------------------------------------------
//   荞ݔ
// -----------------------------------------------------------------------
void IRQH_Int(BYTE irq, void* handler)
{
	int i;
	IRQH_IRQ[irq] = 1;
	if (handler==NULL)
		IRQH_CallBack[irq] = &IRQH_DefaultVector;
	else
		IRQH_CallBack[irq] = handler;
	for (i=7; i>0; i--)
	{
		if (IRQH_IRQ[i])
		{
			regs.irq_callback = IRQH_CallBack[i];
			regs.IRQ_level = i;
			if ( m68000_ICount ) {					// d荞ݎiCARATj
				m68000_ICountBk += m68000_ICount;		// IɊ荞݃`FbN
				m68000_ICount = 0;				// ̍ ^^;
			}
			return;
		}
	}
}
